<%@ page language="java" buffer="none" contentType="text/html; charset=utf-8" %>
<%@ page import="java.util.Iterator" %>
<%@ page import="java.util.Vector" %>
<%@ page import="com.genesyslab.uadthin.customization.realtime.CustomEventPublisher" %>
<%!
    /**
     * PublisherSimulator class publish any messages scheduled.
     */
    class PublisherSimulator implements Runnable {
        private Object datas[] = {
            new Integer(30) ,"ID_001" ,"This text is displayed after 30 seconds",
            new Integer(5)  ,"ID_002" ,"This text is displayed after 35 seconds",
            new Integer(10) ,"ID_003" ,"This text is displayed after 45 seconds",
            new Integer(20) ,"ID_004" ,"This text is displayed after 65 seconds",
            new Integer(30) ,"ID_005" ,"This text is displayed after 95 seconds",
            new Integer(1)  ,"ID_006" ,"This text is displayed after 96 seconds",
            new Integer(5)  ,"ID_007" ,"This text is displayed after 101 seconds",
            new Integer(15) ,"ID_008" ,"This text is displayed after 116 seconds",
            new Integer(30) ,"ID_009" ,"This text is displayed after 146 seconds",
            new Integer(10) ,"ID_010" ,"This text is displayed after 156 seconds",
            new Integer(11) ,"ID_011" ,"This text is displayed after 167 seconds",
            new Integer(3)  ,"ID_012" ,"This text is displayed after 170 seconds",
            new Integer(10) ,"ID_013" ,"This text is displayed after 180 seconds",
            new Integer(10) ,"ID_014" ,"This text is displayed after 190 seconds",
            new Integer(20) ,"ID_015" ,"This text is displayed after 210 seconds",
            new Integer(9)  ,"ID_016" ,"This text is displayed after 219 seconds",
            new Integer(1)  ,"ID_017" ,"This text is displayed after 220 seconds",
            new Integer(2)  ,"ID_018" ,"This text is displayed after 222 seconds",
            new Integer(3)  ,"ID_019" ,"This text is displayed after 225 seconds"
        };
        private CustomEventPublisher customEventPublisher;
        private Thread thread;
        private Vector oldEvents;
        private boolean panelOpened;

        public PublisherSimulator(CustomEventPublisher customEventPublisher) {
            this.customEventPublisher = customEventPublisher;
            oldEvents = new Vector();
            thread = new Thread(this);
            panelOpened = false;
        }

        public void initialize() {
            thread.start();
        }

        public void run() {
            int size = datas.length / 3;

            try {
                for(int inc = 0;inc < size;inc++) {
                    String customEvent[] = {(String)datas[(inc * 3) + 1],(String)datas[(inc * 3) + 2]};

                    Thread.sleep(((Integer)datas[inc * 3]).intValue() * 1000);
                    synchronized(oldEvents) {
                        publish(customEvent);
                    }
                }
            } catch(Exception e) {}
        }

        public void publish(String customEvent[]) {
            if (panelOpened)
                customEventPublisher.publish(customEvent);
            oldEvents.add(customEvent);
        }

        public void openPanel() {
            synchronized(oldEvents) {
                panelOpened = true;
                Iterator iterator = oldEvents.iterator();

                while(iterator.hasNext()) {
                    String customEvent[] = (String[])iterator.next();

                    customEventPublisher.publish(customEvent);
                }
            }
        }

        public void closePanel() {
            synchronized(oldEvents) {
                panelOpened = false;
            }
        }

        public void removeInformation(String idInformation) {
            synchronized(oldEvents) {
                for(int inc = 0;inc < oldEvents.size();inc++) {
                    String customEvent[] = (String[])oldEvents.elementAt(inc);

                    if (idInformation.equals(customEvent[0])) {
                        oldEvents.removeElementAt(inc);
                        break;
                    }
                }
            }
        }
    }
%>
<%
    String action = request.getParameter("action");

    if ("INIT".equals(action)) {
    /* request called on desktop display */
        CustomEventPublisher customEventPublisher = (CustomEventPublisher)session.getAttribute("customEventPublisher");

        if (customEventPublisher != null) {
            PublisherSimulator publisherSimulator = new PublisherSimulator(customEventPublisher);

            session.setAttribute("publisherSimulator",publisherSimulator);
            publisherSimulator.initialize();
        }
    } else {
        PublisherSimulator publisherSimulator = (PublisherSimulator)session.getAttribute("publisherSimulator");

        if (publisherSimulator != null) {
            if ("START".equals(action)) {
            /* request called on custom panel display */
                publisherSimulator.openPanel();
            } else if ("STOP".equals(action)) {
            /* request called on custom panel close */
                publisherSimulator.closePanel();
            } else if ("REMOVE".equals(action)) {
            /* request called to remove a published message */
                publisherSimulator.removeInformation(request.getParameter("idInformation"));
            }
        }
    }
%>
<html>
  <head>
   	<script language="javascript">
      window.parent.includeGDFunctionalities(window);

      function custom_load() {
        activateGDFunctionalities();
      }

      function custom_unload() {
        unactivateGDFunctionalities();
      }
    </script>
  </head>
  <body onload="custom_load()" onunload="custom_unload()">
  </body>
</html>
